// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.JobRouter
{
    /// <summary> A rule providing a binding to an external web server. </summary>
    public partial class WebhookRouterRule : RouterRule
    {
        /// <summary> Initializes a new instance of <see cref="WebhookRouterRule"/>. </summary>
        internal WebhookRouterRule()
        {
            Kind = RouterRuleKind.Webhook;
        }

        /// <summary> Initializes a new instance of <see cref="WebhookRouterRule"/>. </summary>
        /// <param name="kind"> The type discriminator describing a sub-type of RouterRule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="authorizationServerUri"> Uri for Authorization Server. </param>
        /// <param name="clientCredential"> OAuth2.0 Credentials used to Contoso's Authorization server. Reference: https://www.oauth.com/oauth2-servers/access-tokens/client-credentials/. </param>
        /// <param name="webhookUri"> Uri for Contoso's Web Server. </param>
        internal WebhookRouterRule(RouterRuleKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, Uri authorizationServerUri, OAuth2WebhookClientCredential clientCredential, Uri webhookUri) : base(kind, serializedAdditionalRawData)
        {
            AuthorizationServerUri = authorizationServerUri;
            ClientCredential = clientCredential;
            WebhookUri = webhookUri;
        }

        /// <summary> Uri for Authorization Server. </summary>
        public Uri AuthorizationServerUri { get; }
        /// <summary> OAuth2.0 Credentials used to Contoso's Authorization server. Reference: https://www.oauth.com/oauth2-servers/access-tokens/client-credentials/. </summary>
        public OAuth2WebhookClientCredential ClientCredential { get; }
        /// <summary> Uri for Contoso's Web Server. </summary>
        public Uri WebhookUri { get; }
    }
}
