// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.JobRouter
{
    /// <summary> Trigger for an exception action on exceeding wait time. </summary>
    public partial class WaitTimeExceptionTrigger : ExceptionTrigger
    {
        /// <summary> Initializes a new instance of <see cref="WaitTimeExceptionTrigger"/>. </summary>
        /// <param name="kind"> The type discriminator describing a sub-type of ExceptionTrigger. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="threshold"> Threshold for wait time for this trigger. </param>
        internal WaitTimeExceptionTrigger(ExceptionTriggerKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, TimeSpan threshold) : base(kind, serializedAdditionalRawData)
        {
            Threshold = threshold;
        }

        /// <summary> Initializes a new instance of <see cref="WaitTimeExceptionTrigger"/> for deserialization. </summary>
        internal WaitTimeExceptionTrigger()
        {
        }
    }
}
