// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.JobRouter
{
    /// <summary> A rule providing static rules that always return the same result, regardless of input. </summary>
    public partial class StaticRouterRule : RouterRule
    {
        /// <summary> Initializes a new instance of <see cref="StaticRouterRule"/>. </summary>
        internal StaticRouterRule()
        {
            Kind = RouterRuleKind.Static;
        }

        /// <summary> Initializes a new instance of <see cref="StaticRouterRule"/>. </summary>
        /// <param name="kind"> The type discriminator describing a sub-type of RouterRule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> The static value this rule always returns. Values must be primitive values - number, string, boolean. </param>
        internal StaticRouterRule(RouterRuleKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, BinaryData value) : base(kind, serializedAdditionalRawData)
        {
            _value = value;
        }
    }
}
