// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.JobRouter
{
    /// <summary> Describes a matching mode used for scheduling jobs to be queued at a future time. At the specified time, matching worker to a job will not start automatically. </summary>
    public partial class ScheduleAndSuspendMode : JobMatchingMode
    {
        /// <summary> Initializes a new instance of <see cref="ScheduleAndSuspendMode"/>. </summary>
        /// <param name="kind"> The type discriminator describing a sub-type of JobMatchingMode. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="scheduleAt"> Requested schedule time. </param>
        internal ScheduleAndSuspendMode(JobMatchingModeKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, DateTimeOffset scheduleAt) : base(kind, serializedAdditionalRawData)
        {
            ScheduleAt = scheduleAt;
        }

        /// <summary> Initializes a new instance of <see cref="ScheduleAndSuspendMode"/> for deserialization. </summary>
        internal ScheduleAndSuspendMode()
        {
        }

        /// <summary> Requested schedule time. </summary>
        public DateTimeOffset ScheduleAt { get; }
    }
}
