// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.JobRouter
{
    /// <summary> Describes the status of a worker selector. </summary>
    public readonly partial struct RouterWorkerSelectorStatus : IEquatable<RouterWorkerSelectorStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RouterWorkerSelectorStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RouterWorkerSelectorStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "active";
        private const string ExpiredValue = "expired";

        /// <summary> Worker selector is valid. </summary>
        public static RouterWorkerSelectorStatus Active { get; } = new RouterWorkerSelectorStatus(ActiveValue);
        /// <summary> Worker selector is not valid. </summary>
        public static RouterWorkerSelectorStatus Expired { get; } = new RouterWorkerSelectorStatus(ExpiredValue);
        /// <summary> Determines if two <see cref="RouterWorkerSelectorStatus"/> values are the same. </summary>
        public static bool operator ==(RouterWorkerSelectorStatus left, RouterWorkerSelectorStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RouterWorkerSelectorStatus"/> values are not the same. </summary>
        public static bool operator !=(RouterWorkerSelectorStatus left, RouterWorkerSelectorStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RouterWorkerSelectorStatus"/>. </summary>
        public static implicit operator RouterWorkerSelectorStatus(string value) => new RouterWorkerSelectorStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RouterWorkerSelectorStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RouterWorkerSelectorStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
