// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.JobRouter
{
    /// <summary> Enums used to filters jobs by status. </summary>
    public readonly partial struct RouterJobStatusSelector : IEquatable<RouterJobStatusSelector>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RouterJobStatusSelector"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RouterJobStatusSelector(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllValue = "all";
        private const string PendingClassificationValue = "pendingClassification";
        private const string QueuedValue = "queued";
        private const string AssignedValue = "assigned";
        private const string CompletedValue = "completed";
        private const string ClosedValue = "closed";
        private const string CancelledValue = "cancelled";
        private const string ClassificationFailedValue = "classificationFailed";
        private const string CreatedValue = "created";
        private const string PendingScheduleValue = "pendingSchedule";
        private const string ScheduledValue = "scheduled";
        private const string ScheduleFailedValue = "scheduleFailed";
        private const string WaitingForActivationValue = "waitingForActivation";
        private const string ActiveValue = "active";

        /// <summary> Default. </summary>
        public static RouterJobStatusSelector All { get; } = new RouterJobStatusSelector(AllValue);
        /// <summary> Job is waiting to be classified. </summary>
        public static RouterJobStatusSelector PendingClassification { get; } = new RouterJobStatusSelector(PendingClassificationValue);
        /// <summary> Job has been queued. </summary>
        public static RouterJobStatusSelector Queued { get; } = new RouterJobStatusSelector(QueuedValue);
        /// <summary> Job has been assigned to a worker. </summary>
        public static RouterJobStatusSelector Assigned { get; } = new RouterJobStatusSelector(AssignedValue);
        /// <summary> Job has been completed by a worker. </summary>
        public static RouterJobStatusSelector Completed { get; } = new RouterJobStatusSelector(CompletedValue);
        /// <summary> Job has been closed by a worker. </summary>
        public static RouterJobStatusSelector Closed { get; } = new RouterJobStatusSelector(ClosedValue);
        /// <summary> Job has been cancelled. </summary>
        public static RouterJobStatusSelector Cancelled { get; } = new RouterJobStatusSelector(CancelledValue);
        /// <summary> Classification process failed for the job. </summary>
        public static RouterJobStatusSelector ClassificationFailed { get; } = new RouterJobStatusSelector(ClassificationFailedValue);
        /// <summary> Job has been created. </summary>
        public static RouterJobStatusSelector Created { get; } = new RouterJobStatusSelector(CreatedValue);
        /// <summary> Job has been created but not been scheduled yet. </summary>
        public static RouterJobStatusSelector PendingSchedule { get; } = new RouterJobStatusSelector(PendingScheduleValue);
        /// <summary> Job has been scheduled successfully. </summary>
        public static RouterJobStatusSelector Scheduled { get; } = new RouterJobStatusSelector(ScheduledValue);
        /// <summary> Job scheduling failed. </summary>
        public static RouterJobStatusSelector ScheduleFailed { get; } = new RouterJobStatusSelector(ScheduleFailedValue);
        /// <summary> Job is in a suspended state and waiting for an update. </summary>
        public static RouterJobStatusSelector WaitingForActivation { get; } = new RouterJobStatusSelector(WaitingForActivationValue);
        /// <summary> Job is in a state of PendingClassification or Queued or Assigned or ClassificationFailed or Completed or PendingSchedule or Scheduled or ScheduleFailed or WaitingForActivation. </summary>
        public static RouterJobStatusSelector Active { get; } = new RouterJobStatusSelector(ActiveValue);
        /// <summary> Determines if two <see cref="RouterJobStatusSelector"/> values are the same. </summary>
        public static bool operator ==(RouterJobStatusSelector left, RouterJobStatusSelector right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RouterJobStatusSelector"/> values are not the same. </summary>
        public static bool operator !=(RouterJobStatusSelector left, RouterJobStatusSelector right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RouterJobStatusSelector"/>. </summary>
        public static implicit operator RouterJobStatusSelector(string value) => new RouterJobStatusSelector(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RouterJobStatusSelector other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RouterJobStatusSelector other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
