// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.JobRouter
{
    /// <summary> Discriminators for supported queue selector attachment types. </summary>
    public readonly partial struct QueueSelectorAttachmentKind : IEquatable<QueueSelectorAttachmentKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="QueueSelectorAttachmentKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public QueueSelectorAttachmentKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConditionalValue = "conditional";
        private const string PassThroughValue = "passThrough";
        private const string RuleEngineValue = "ruleEngine";
        private const string StaticValue = "static";
        private const string WeightedAllocationValue = "weightedAllocation";

        /// <summary> Discriminator value for ConditionalQueueSelectorAttachment. </summary>
        public static QueueSelectorAttachmentKind Conditional { get; } = new QueueSelectorAttachmentKind(ConditionalValue);
        /// <summary> Discriminator value for PassThroughQueueSelectorAttachment. </summary>
        public static QueueSelectorAttachmentKind PassThrough { get; } = new QueueSelectorAttachmentKind(PassThroughValue);
        /// <summary> Discriminator value for RuleEngineQueueSelectorAttachment. </summary>
        public static QueueSelectorAttachmentKind RuleEngine { get; } = new QueueSelectorAttachmentKind(RuleEngineValue);
        /// <summary> Discriminator value for StaticQueueSelectorAttachment. </summary>
        public static QueueSelectorAttachmentKind Static { get; } = new QueueSelectorAttachmentKind(StaticValue);
        /// <summary> Discriminator value for WeightedAllocationQueueSelectorAttachment. </summary>
        public static QueueSelectorAttachmentKind WeightedAllocation { get; } = new QueueSelectorAttachmentKind(WeightedAllocationValue);
        /// <summary> Determines if two <see cref="QueueSelectorAttachmentKind"/> values are the same. </summary>
        public static bool operator ==(QueueSelectorAttachmentKind left, QueueSelectorAttachmentKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="QueueSelectorAttachmentKind"/> values are not the same. </summary>
        public static bool operator !=(QueueSelectorAttachmentKind left, QueueSelectorAttachmentKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="QueueSelectorAttachmentKind"/>. </summary>
        public static implicit operator QueueSelectorAttachmentKind(string value) => new QueueSelectorAttachmentKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is QueueSelectorAttachmentKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(QueueSelectorAttachmentKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
