// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.JobRouter
{
    /// <summary> Attaches a worker selector where the value is passed through from a job's label with the same key. </summary>
    public partial class PassThroughWorkerSelectorAttachment : WorkerSelectorAttachment
    {
        /// <summary> Initializes a new instance of <see cref="PassThroughWorkerSelectorAttachment"/>. </summary>
        /// <param name="key"> The label key to query against. </param>
        /// <param name="labelOperator"> Describes how the value of the label is compared to the value pass through. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> is null. </exception>
        internal PassThroughWorkerSelectorAttachment(string key, LabelOperator labelOperator)
        {
            Argument.AssertNotNull(key, nameof(key));

            Kind = WorkerSelectorAttachmentKind.PassThrough;
            Key = key;
            LabelOperator = labelOperator;
        }

        /// <summary> Initializes a new instance of <see cref="PassThroughWorkerSelectorAttachment"/>. </summary>
        /// <param name="kind"> The type discriminator describing a sub-type of WorkerSelectorAttachment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="key"> The label key to query against. </param>
        /// <param name="labelOperator"> Describes how the value of the label is compared to the value pass through. </param>
        /// <param name="expiresAfter"> Describes how long the attached label selector is valid in seconds. </param>
        internal PassThroughWorkerSelectorAttachment(WorkerSelectorAttachmentKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, string key, LabelOperator labelOperator, TimeSpan? expiresAfter) : base(kind, serializedAdditionalRawData)
        {
            Key = key;
            LabelOperator = labelOperator;
            ExpiresAfter = expiresAfter;
        }

        /// <summary> Initializes a new instance of <see cref="PassThroughWorkerSelectorAttachment"/> for deserialization. </summary>
        internal PassThroughWorkerSelectorAttachment()
        {
        }

        /// <summary> The label key to query against. </summary>
        public string Key { get; }
    }
}
