// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.JobRouter
{
    /// <summary> Credentials used to access Azure function rule. </summary>
    public partial class FunctionRouterRuleCredential
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FunctionRouterRuleCredential"/>. </summary>
        internal FunctionRouterRuleCredential()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FunctionRouterRuleCredential"/>. </summary>
        /// <param name="functionKey"> Access key scoped to a particular function. </param>
        /// <param name="appKey"> Access key scoped to a Azure Function app. This key grants access to all functions under the app. </param>
        /// <param name="clientId"> Client id, when AppKey is provided In context of Azure function, this is usually the name of the key. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FunctionRouterRuleCredential(string functionKey, string appKey, string clientId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FunctionKey = functionKey;
            AppKey = appKey;
            ClientId = clientId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }
    }
}
