// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.JobRouter
{
    /// <summary> A rule providing a binding to an HTTP Triggered Azure Function. </summary>
    public partial class FunctionRouterRule : RouterRule
    {
        /// <summary> Initializes a new instance of <see cref="FunctionRouterRule"/>. </summary>
        /// <param name="kind"> The type discriminator describing a sub-type of RouterRule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="functionUri"> URL for Azure Function. </param>
        /// <param name="credential"> Credentials used to access Azure function rule. </param>
        internal FunctionRouterRule(RouterRuleKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, Uri functionUri, FunctionRouterRuleCredential credential) : base(kind, serializedAdditionalRawData)
        {
            FunctionUri = functionUri;
            Credential = credential;
        }

        /// <summary> Initializes a new instance of <see cref="FunctionRouterRule"/> for deserialization. </summary>
        internal FunctionRouterRule()
        {
        }

        /// <summary> URL for Azure Function. </summary>
        public Uri FunctionUri { get; }
    }
}
