// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.JobRouter
{
    /// <summary> A rule providing inline expression rules. </summary>
    public partial class ExpressionRouterRule : RouterRule
    {
        /// <summary> Initializes a new instance of <see cref="ExpressionRouterRule"/>. </summary>
        /// <param name="kind"> The type discriminator describing a sub-type of RouterRule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="language"> The expression language to compile to and execute. </param>
        /// <param name="expression"> An expression to evaluate. Should contain return statement with calculated values. </param>
        internal ExpressionRouterRule(RouterRuleKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, string language, string expression) : base(kind, serializedAdditionalRawData)
        {
            Language = language;
            Expression = expression;
        }

        /// <summary> Initializes a new instance of <see cref="ExpressionRouterRule"/> for deserialization. </summary>
        internal ExpressionRouterRule()
        {
        }
        /// <summary> An expression to evaluate. Should contain return statement with calculated values. </summary>
        public string Expression { get; }
    }
}
