// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.JobRouter
{
    /// <summary> Discriminators for supported exception trigger types. </summary>
    public readonly partial struct ExceptionTriggerKind : IEquatable<ExceptionTriggerKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExceptionTriggerKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExceptionTriggerKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string QueueLengthValue = "queueLength";
        private const string WaitTimeValue = "waitTime";

        /// <summary> Discriminator value for QueueLengthExceptionTrigger. </summary>
        public static ExceptionTriggerKind QueueLength { get; } = new ExceptionTriggerKind(QueueLengthValue);
        /// <summary> Discriminator value for WaitTimeExceptionTrigger. </summary>
        public static ExceptionTriggerKind WaitTime { get; } = new ExceptionTriggerKind(WaitTimeValue);
        /// <summary> Determines if two <see cref="ExceptionTriggerKind"/> values are the same. </summary>
        public static bool operator ==(ExceptionTriggerKind left, ExceptionTriggerKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExceptionTriggerKind"/> values are not the same. </summary>
        public static bool operator !=(ExceptionTriggerKind left, ExceptionTriggerKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExceptionTriggerKind"/>. </summary>
        public static implicit operator ExceptionTriggerKind(string value) => new ExceptionTriggerKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExceptionTriggerKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExceptionTriggerKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
