// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.JobRouter
{
    /// <summary> Discriminators for supported distribution mode types. </summary>
    public readonly partial struct DistributionModeKind : IEquatable<DistributionModeKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DistributionModeKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DistributionModeKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BestWorkerValue = "bestWorker";
        private const string LongestIdleValue = "longestIdle";
        private const string RoundRobinValue = "roundRobin";

        /// <summary> Discriminator value for BestWorkerMode. </summary>
        public static DistributionModeKind BestWorker { get; } = new DistributionModeKind(BestWorkerValue);
        /// <summary> Discriminator value for LongestIdleMode. </summary>
        public static DistributionModeKind LongestIdle { get; } = new DistributionModeKind(LongestIdleValue);
        /// <summary> Discriminator value for RoundRobinMode. </summary>
        public static DistributionModeKind RoundRobin { get; } = new DistributionModeKind(RoundRobinValue);
        /// <summary> Determines if two <see cref="DistributionModeKind"/> values are the same. </summary>
        public static bool operator ==(DistributionModeKind left, DistributionModeKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DistributionModeKind"/> values are not the same. </summary>
        public static bool operator !=(DistributionModeKind left, DistributionModeKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DistributionModeKind"/>. </summary>
        public static implicit operator DistributionModeKind(string value) => new DistributionModeKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DistributionModeKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DistributionModeKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
