// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Communication.JobRouter
{
    public partial class ClassificationPolicy : IUtf8JsonSerializable, IJsonModel<ClassificationPolicy>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ClassificationPolicy>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ClassificationPolicy>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClassificationPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClassificationPolicy)} does not support writing '{format}' format.");
            }

            if (options.Format != "W")
            {
                writer.WritePropertyName("etag"u8);
                writer.WriteStringValue(ETag.ToString());
            }
            if (options.Format != "W")
            {
                writer.WritePropertyName("id"u8);
                writer.WriteStringValue(Id);
            }
            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(FallbackQueueId))
            {
                writer.WritePropertyName("fallbackQueueId"u8);
                writer.WriteStringValue(FallbackQueueId);
            }
            if (Optional.IsCollectionDefined(QueueSelectorAttachments))
            {
                writer.WritePropertyName("queueSelectorAttachments"u8);
                writer.WriteStartArray();
                foreach (var item in QueueSelectorAttachments)
                {
                    writer.WriteObjectValue<QueueSelectorAttachment>(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(PrioritizationRule))
            {
                writer.WritePropertyName("prioritizationRule"u8);
                writer.WriteObjectValue<RouterRule>(PrioritizationRule, options);
            }
            if (Optional.IsCollectionDefined(WorkerSelectorAttachments))
            {
                writer.WritePropertyName("workerSelectorAttachments"u8);
                writer.WriteStartArray();
                foreach (var item in WorkerSelectorAttachments)
                {
                    writer.WriteObjectValue<WorkerSelectorAttachment>(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ClassificationPolicy IJsonModel<ClassificationPolicy>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClassificationPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClassificationPolicy)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeClassificationPolicy(document.RootElement, options);
        }

        internal static ClassificationPolicy DeserializeClassificationPolicy(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ETag etag = default;
            string id = default;
            string name = default;
            string fallbackQueueId = default;
            IList<QueueSelectorAttachment> queueSelectorAttachments = default;
            RouterRule prioritizationRule = default;
            IList<WorkerSelectorAttachment> workerSelectorAttachments = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("etag"u8))
                {
                    etag = new ETag(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fallbackQueueId"u8))
                {
                    fallbackQueueId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("queueSelectorAttachments"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<QueueSelectorAttachment> array = new List<QueueSelectorAttachment>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(QueueSelectorAttachment.DeserializeQueueSelectorAttachment(item, options));
                    }
                    queueSelectorAttachments = array;
                    continue;
                }
                if (property.NameEquals("prioritizationRule"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    prioritizationRule = RouterRule.DeserializeRouterRule(property.Value, options);
                    continue;
                }
                if (property.NameEquals("workerSelectorAttachments"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<WorkerSelectorAttachment> array = new List<WorkerSelectorAttachment>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(WorkerSelectorAttachment.DeserializeWorkerSelectorAttachment(item, options));
                    }
                    workerSelectorAttachments = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ClassificationPolicy(
                etag,
                id,
                name,
                fallbackQueueId,
                queueSelectorAttachments ?? new ChangeTrackingList<QueueSelectorAttachment>(),
                prioritizationRule,
                workerSelectorAttachments ?? new ChangeTrackingList<WorkerSelectorAttachment>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ClassificationPolicy>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClassificationPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ClassificationPolicy)} does not support writing '{options.Format}' format.");
            }
        }

        ClassificationPolicy IPersistableModel<ClassificationPolicy>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClassificationPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeClassificationPolicy(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ClassificationPolicy)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ClassificationPolicy>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ClassificationPolicy FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeClassificationPolicy(document.RootElement);
        }
    }
}
