// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.Identity
{
    /// <summary> List of scopes for an access token. </summary>
    public readonly partial struct CommunicationTokenScope : IEquatable<CommunicationTokenScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CommunicationTokenScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CommunicationTokenScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ChatValue = "chat";
        private const string VoIPValue = "voip";
        private const string ChatJoinValue = "chat.join";
        private const string ChatJoinLimitedValue = "chat.join.limited";
        private const string VoIPJoinValue = "voip.join";

        /// <summary> Use this for full access to Chat APIs. </summary>
        public static CommunicationTokenScope Chat { get; } = new CommunicationTokenScope(ChatValue);
        /// <summary> Access to Chat APIs but without the authorization to create, delete or update chat threads. </summary>
        public static CommunicationTokenScope ChatJoin { get; } = new CommunicationTokenScope(ChatJoinValue);
        /// <summary> A more limited version of chat.join that doesn't allow to add or remove participants. Use this scope when the token bearer is not fully trusted, for example in guest scenarios. </summary>
        public static CommunicationTokenScope ChatJoinLimited { get; } = new CommunicationTokenScope(ChatJoinLimitedValue);
        /// <summary> Determines if two <see cref="CommunicationTokenScope"/> values are the same. </summary>
        public static bool operator ==(CommunicationTokenScope left, CommunicationTokenScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CommunicationTokenScope"/> values are not the same. </summary>
        public static bool operator !=(CommunicationTokenScope left, CommunicationTokenScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CommunicationTokenScope"/>. </summary>
        public static implicit operator CommunicationTokenScope(string value) => new CommunicationTokenScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CommunicationTokenScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CommunicationTokenScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
