// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Communication.Identity.Models
{
    /// <summary> The CommunicationIdentityCreateRequest. </summary>
    internal partial class CommunicationIdentityCreateRequest
    {
        /// <summary> Initializes a new instance of <see cref="CommunicationIdentityCreateRequest"/>. </summary>
        public CommunicationIdentityCreateRequest()
        {
            CreateTokenWithScopes = new ChangeTrackingList<CommunicationTokenScope>();
        }

        /// <summary> Initializes a new instance of <see cref="CommunicationIdentityCreateRequest"/>. </summary>
        /// <param name="createTokenWithScopes"> Also create access token for the created identity. </param>
        /// <param name="expiresInMinutes"> Optional custom validity period of the token within [60,1440] minutes range. If not provided, the default value of 1440 minutes (24 hours) will be used. </param>
        internal CommunicationIdentityCreateRequest(IList<CommunicationTokenScope> createTokenWithScopes, int? expiresInMinutes)
        {
            CreateTokenWithScopes = createTokenWithScopes;
            ExpiresInMinutes = expiresInMinutes;
        }

        /// <summary> Also create access token for the created identity. </summary>
        public IList<CommunicationTokenScope> CreateTokenWithScopes { get; }
        /// <summary> Optional custom validity period of the token within [60,1440] minutes range. If not provided, the default value of 1440 minutes (24 hours) will be used. </summary>
        public int? ExpiresInMinutes { get; set; }
    }
}
