// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.Identity
{
    /// <summary> An access token. </summary>
    internal partial class CommunicationIdentityAccessToken
    {
        /// <summary> Initializes a new instance of <see cref="CommunicationIdentityAccessToken"/>. </summary>
        /// <param name="token"> The access token issued for the identity. </param>
        /// <param name="expiresOn"> The expiry time of the token. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="token"/> is null. </exception>
        internal CommunicationIdentityAccessToken(string token, DateTimeOffset expiresOn)
        {
            Argument.AssertNotNull(token, nameof(token));

            Token = token;
            ExpiresOn = expiresOn;
        }

        /// <summary> The access token issued for the identity. </summary>
        public string Token { get; }
        /// <summary> The expiry time of the token. </summary>
        public DateTimeOffset ExpiresOn { get; }
    }
}
