// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.Identity.Models
{
    /// <summary> A communication identity. </summary>
    internal partial class CommunicationIdentity
    {
        /// <summary> Initializes a new instance of <see cref="CommunicationIdentity"/>. </summary>
        /// <param name="id"> Identifier of the identity. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        internal CommunicationIdentity(string id)
        {
            Argument.AssertNotNull(id, nameof(id));

            Id = id;
        }

        /// <summary> Identifier of the identity. </summary>
        public string Id { get; }
    }
}
