// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.Email
{
    /// <summary> Status of operation. </summary>
    public readonly partial struct EmailSendStatus : IEquatable<EmailSendStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EmailSendStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EmailSendStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotStartedValue = "NotStarted";
        private const string RunningValue = "Running";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> NotStarted. </summary>
        public static EmailSendStatus NotStarted { get; } = new EmailSendStatus(NotStartedValue);
        /// <summary> Running. </summary>
        public static EmailSendStatus Running { get; } = new EmailSendStatus(RunningValue);
        /// <summary> Succeeded. </summary>
        public static EmailSendStatus Succeeded { get; } = new EmailSendStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static EmailSendStatus Failed { get; } = new EmailSendStatus(FailedValue);
        /// <summary> Canceled. </summary>
        public static EmailSendStatus Canceled { get; } = new EmailSendStatus(CanceledValue);
        /// <summary> Determines if two <see cref="EmailSendStatus"/> values are the same. </summary>
        public static bool operator ==(EmailSendStatus left, EmailSendStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EmailSendStatus"/> values are not the same. </summary>
        public static bool operator !=(EmailSendStatus left, EmailSendStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EmailSendStatus"/>. </summary>
        public static implicit operator EmailSendStatus(string value) => new EmailSendStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EmailSendStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EmailSendStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
