// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Communication.Email
{
    /// <summary> Recipients of the email. </summary>
    public partial class EmailRecipients
    {
        /// <summary> Initializes a new instance of <see cref="EmailRecipients"/>. </summary>
        /// <param name="to"> Email To recipients. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="to"/> is null. </exception>
        public EmailRecipients(IEnumerable<EmailAddress> to)
        {
            Argument.AssertNotNull(to, nameof(to));

            To = to.ToList();
            CC = new ChangeTrackingList<EmailAddress>();
            BCC = new ChangeTrackingList<EmailAddress>();
        }

        /// <summary> Initializes a new instance of <see cref="EmailRecipients"/>. </summary>
        /// <param name="to"> Email To recipients. </param>
        /// <param name="cc"> Email CC recipients. </param>
        /// <param name="bcc"> Email BCC recipients. </param>
        internal EmailRecipients(IList<EmailAddress> to, IList<EmailAddress> cc, IList<EmailAddress> bcc)
        {
            To = to;
            CC = cc;
            BCC = bcc;
        }

        /// <summary> Email To recipients. </summary>
        public IList<EmailAddress> To { get; }
        /// <summary> Email CC recipients. </summary>
        public IList<EmailAddress> CC { get; }
        /// <summary> Email BCC recipients. </summary>
        public IList<EmailAddress> BCC { get; }
    }
}
