// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.Email
{
    /// <summary> Message payload for sending an email. </summary>
    public partial class EmailMessage
    {
        /// <summary> Initializes a new instance of <see cref="EmailMessage"/>. </summary>
        /// <param name="headers"> Custom email headers to be passed. </param>
        /// <param name="senderAddress"> Sender email address from a verified domain. </param>
        /// <param name="content"> Email content to be sent. </param>
        /// <param name="recipients"> Recipients for the email. </param>
        /// <param name="attachments"> List of attachments. Please note that we limit the total size of an email request (which includes both regular and inline attachments) to 10MB. </param>
        /// <param name="replyTo"> Email addresses where recipients' replies will be sent to. </param>
        /// <param name="userEngagementTrackingDisabled"> Indicates whether user engagement tracking should be disabled for this request if the resource-level user engagement tracking setting was already enabled in the control plane. </param>
        internal EmailMessage(IDictionary<string, string> headers, string senderAddress, EmailContent content, EmailRecipients recipients, IList<EmailAttachment> attachments, IList<EmailAddress> replyTo, bool? userEngagementTrackingDisabled)
        {
            Headers = headers;
            SenderAddress = senderAddress;
            Content = content;
            Recipients = recipients;
            Attachments = attachments;
            ReplyTo = replyTo;
            UserEngagementTrackingDisabled = userEngagementTrackingDisabled;
        }

        /// <summary> Custom email headers to be passed. </summary>
        public IDictionary<string, string> Headers { get; }
        /// <summary> Sender email address from a verified domain. </summary>
        public string SenderAddress { get; }
        /// <summary> Email content to be sent. </summary>
        public EmailContent Content { get; }
        /// <summary> Recipients for the email. </summary>
        public EmailRecipients Recipients { get; }
        /// <summary> List of attachments. Please note that we limit the total size of an email request (which includes both regular and inline attachments) to 10MB. </summary>
        public IList<EmailAttachment> Attachments { get; }
        /// <summary> Email addresses where recipients' replies will be sent to. </summary>
        public IList<EmailAddress> ReplyTo { get; }
        /// <summary> Indicates whether user engagement tracking should be disabled for this request if the resource-level user engagement tracking setting was already enabled in the control plane. </summary>
        public bool? UserEngagementTrackingDisabled { get; set; }
    }
}
