// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Communication.Email
{
    public partial class EmailMessage : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsCollectionDefined(Headers))
            {
                writer.WritePropertyName("headers"u8);
                writer.WriteStartObject();
                foreach (var item in Headers)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WritePropertyName("senderAddress"u8);
            writer.WriteStringValue(SenderAddress);
            writer.WritePropertyName("content"u8);
            writer.WriteObjectValue(Content);
            writer.WritePropertyName("recipients"u8);
            writer.WriteObjectValue(Recipients);
            if (Optional.IsCollectionDefined(Attachments))
            {
                writer.WritePropertyName("attachments"u8);
                writer.WriteStartArray();
                foreach (var item in Attachments)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ReplyTo))
            {
                writer.WritePropertyName("replyTo"u8);
                writer.WriteStartArray();
                foreach (var item in ReplyTo)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(UserEngagementTrackingDisabled))
            {
                writer.WritePropertyName("userEngagementTrackingDisabled"u8);
                writer.WriteBooleanValue(UserEngagementTrackingDisabled.Value);
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
