// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Communication.Email
{
    public partial class EmailContent : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("subject"u8);
            writer.WriteStringValue(Subject);
            if (Optional.IsDefined(PlainText))
            {
                writer.WritePropertyName("plainText"u8);
                writer.WriteStringValue(PlainText);
            }
            if (Optional.IsDefined(Html))
            {
                writer.WritePropertyName("html"u8);
                writer.WriteStringValue(Html);
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
