// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.Communication.Email
{
    internal partial class EmailSendHeaders
    {
        private readonly Response _response;
        public EmailSendHeaders(Response response)
        {
            _response = response;
        }
        /// <summary> Location url of where to poll the status of this operation from. </summary>
        public string OperationLocation => _response.Headers.TryGetValue("Operation-Location", out string value) ? value : null;
        /// <summary> This header will only be present when the operation status is a non-terminal status. It indicates the minimum amount of time in seconds to wait before polling for operation status again. </summary>
        public int? RetryAfter => _response.Headers.TryGetValue("retry-after", out int? value) ? value : null;
    }
}
