// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Communication.Email
{
    internal partial class EmailRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of EmailRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> The communication resource, for example https://my-resource.communication.azure.com. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/>, <paramref name="endpoint"/> or <paramref name="apiVersion"/> is null. </exception>
        public EmailRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint, string apiVersion = "2024-07-01-preview")
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? throw new ArgumentNullException(nameof(endpoint));
            _apiVersion = apiVersion ?? throw new ArgumentNullException(nameof(apiVersion));
        }

        internal HttpMessage CreateGetSendResultRequest(string operationId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/emails/operations/", false);
            uri.AppendPath(operationId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Gets the status of the email send operation. </summary>
        /// <param name="operationId"> ID of the long running operation (GUID) returned from a previous call to send email. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="operationId"/> is null. </exception>
        public async Task<ResponseWithHeaders<EmailSendResult, EmailGetSendResultHeaders>> GetSendResultAsync(string operationId, CancellationToken cancellationToken = default)
        {
            if (operationId == null)
            {
                throw new ArgumentNullException(nameof(operationId));
            }

            using var message = CreateGetSendResultRequest(operationId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new EmailGetSendResultHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        EmailSendResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = EmailSendResult.DeserializeEmailSendResult(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets the status of the email send operation. </summary>
        /// <param name="operationId"> ID of the long running operation (GUID) returned from a previous call to send email. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="operationId"/> is null. </exception>
        public ResponseWithHeaders<EmailSendResult, EmailGetSendResultHeaders> GetSendResult(string operationId, CancellationToken cancellationToken = default)
        {
            if (operationId == null)
            {
                throw new ArgumentNullException(nameof(operationId));
            }

            using var message = CreateGetSendResultRequest(operationId);
            _pipeline.Send(message, cancellationToken);
            var headers = new EmailGetSendResultHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        EmailSendResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = EmailSendResult.DeserializeEmailSendResult(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateSendRequest(EmailMessage message, Guid? operationId)
        {
            var message0 = _pipeline.CreateMessage();
            var request = message0.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/emails:send", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (operationId != null)
            {
                request.Headers.Add("Operation-Id", operationId.Value);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(message);
            request.Content = content;
            return message0;
        }

        /// <summary> Queues an email message to be sent to one or more recipients. </summary>
        /// <param name="message"> Message payload for sending an email. </param>
        /// <param name="operationId"> This is the ID provided by the customer to identify the long running operation. If an ID is not provided by the customer, the service will generate one. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="message"/> is null. </exception>
        public async Task<ResponseWithHeaders<EmailSendHeaders>> SendAsync(EmailMessage message, Guid? operationId = null, CancellationToken cancellationToken = default)
        {
            if (message == null)
            {
                throw new ArgumentNullException(nameof(message));
            }

            using var message0 = CreateSendRequest(message, operationId);
            await _pipeline.SendAsync(message0, cancellationToken).ConfigureAwait(false);
            var headers = new EmailSendHeaders(message0.Response);
            switch (message0.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message0.Response);
                default:
                    throw new RequestFailedException(message0.Response);
            }
        }

        /// <summary> Queues an email message to be sent to one or more recipients. </summary>
        /// <param name="message"> Message payload for sending an email. </param>
        /// <param name="operationId"> This is the ID provided by the customer to identify the long running operation. If an ID is not provided by the customer, the service will generate one. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="message"/> is null. </exception>
        public ResponseWithHeaders<EmailSendHeaders> Send(EmailMessage message, Guid? operationId = null, CancellationToken cancellationToken = default)
        {
            if (message == null)
            {
                throw new ArgumentNullException(nameof(message));
            }

            using var message0 = CreateSendRequest(message, operationId);
            _pipeline.Send(message0, cancellationToken);
            var headers = new EmailSendHeaders(message0.Response);
            switch (message0.Response.Status)
            {
                case 202:
                    return ResponseWithHeaders.FromValue(headers, message0.Response);
                default:
                    throw new RequestFailedException(message0.Response);
            }
        }
    }
}
