// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

#nullable disable

using System;

namespace Azure.Communication.Chat
{
    /// <summary> A chat message read receipt indicates the time a chat message was read by a recipient. </summary>
    public partial class ChatMessageReadReceipt
    {
        internal ChatMessageReadReceipt(CommunicationIdentifier sender, string chatMessageId, DateTimeOffset readOn)
        {
            Sender = sender;
            ChatMessageId = chatMessageId;
            ReadOn = readOn;
        }

        internal ChatMessageReadReceipt(ChatMessageReadReceiptInternal chatMessageReadReceiptInternal)
        {
            Sender = CommunicationIdentifierSerializer.Deserialize(chatMessageReadReceiptInternal.SenderCommunicationIdentifier);
            ChatMessageId = chatMessageReadReceiptInternal.ChatMessageId;
            ReadOn = chatMessageReadReceiptInternal.ReadOn;
        }

        /// <summary> Identifies a participant in Azure Communication services. A participant is, for example, a phone number or an Azure communication user. This model must be interpreted as a union: Apart from rawId, at most one further property may be set. </summary>
        public CommunicationIdentifier Sender { get; }
        /// <summary> Id of the chat message that has been read. This id is generated by the server. </summary>
        public string ChatMessageId { get; }
        /// <summary> The time at which the message was read. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </summary>
        public DateTimeOffset ReadOn { get; }
    }
}
