// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.Chat
{
    /// <summary> Details of the message to send. </summary>
    internal partial class SendChatMessageRequest
    {
        /// <summary> Initializes a new instance of <see cref="SendChatMessageRequest"/>. </summary>
        /// <param name="content"> Chat message content. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public SendChatMessageRequest(string content)
        {
            Argument.AssertNotNull(content, nameof(content));

            Content = content;
            Metadata = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="SendChatMessageRequest"/>. </summary>
        /// <param name="content"> Chat message content. </param>
        /// <param name="senderDisplayName"> The display name of the chat message sender. This property is used to populate sender name for push notifications. </param>
        /// <param name="type"> The chat message type. </param>
        /// <param name="metadata"> Message metadata. </param>
        internal SendChatMessageRequest(string content, string senderDisplayName, ChatMessageType? type, IDictionary<string, string> metadata)
        {
            Content = content;
            SenderDisplayName = senderDisplayName;
            Type = type;
            Metadata = metadata;
        }

        /// <summary> Chat message content. </summary>
        public string Content { get; }
        /// <summary> The display name of the chat message sender. This property is used to populate sender name for push notifications. </summary>
        public string SenderDisplayName { get; set; }
        /// <summary> The chat message type. </summary>
        public ChatMessageType? Type { get; set; }
        /// <summary> Message metadata. </summary>
        public IDictionary<string, string> Metadata { get; }
    }
}
