// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.Chat
{
    /// <summary> Summary information of a chat thread. </summary>
    public partial class ChatThreadItem
    {
        /// <summary> Initializes a new instance of <see cref="ChatThreadItem"/>. </summary>
        /// <param name="id"> Chat thread id. </param>
        /// <param name="topic"> Chat thread topic. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="topic"/> is null. </exception>
        internal ChatThreadItem(string id, string topic)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(topic, nameof(topic));

            Id = id;
            Topic = topic;
        }

        /// <summary> Initializes a new instance of <see cref="ChatThreadItem"/>. </summary>
        /// <param name="id"> Chat thread id. </param>
        /// <param name="topic"> Chat thread topic. </param>
        /// <param name="deletedOn"> The timestamp when the chat thread was deleted. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </param>
        /// <param name="lastMessageReceivedOn"> The timestamp when the last message arrived at the server. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </param>
        internal ChatThreadItem(string id, string topic, DateTimeOffset? deletedOn, DateTimeOffset? lastMessageReceivedOn)
        {
            Id = id;
            Topic = topic;
            DeletedOn = deletedOn;
            LastMessageReceivedOn = lastMessageReceivedOn;
        }

        /// <summary> Chat thread id. </summary>
        public string Id { get; }
        /// <summary> Chat thread topic. </summary>
        public string Topic { get; }
        /// <summary> The timestamp when the chat thread was deleted. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </summary>
        public DateTimeOffset? DeletedOn { get; }
        /// <summary> The timestamp when the last message arrived at the server. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </summary>
        public DateTimeOffset? LastMessageReceivedOn { get; }
    }
}
