// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Communication.Chat
{
    internal partial class ChatMessageReadReceiptsCollection
    {
        internal static ChatMessageReadReceiptsCollection DeserializeChatMessageReadReceiptsCollection(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<ChatMessageReadReceiptInternal> value = default;
            string nextLink = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<ChatMessageReadReceiptInternal> array = new List<ChatMessageReadReceiptInternal>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ChatMessageReadReceiptInternal.DeserializeChatMessageReadReceiptInternal(item));
                    }
                    value = array;
                    continue;
                }
                if (property.NameEquals("nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
            }
            return new ChatMessageReadReceiptsCollection(value, nextLink);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ChatMessageReadReceiptsCollection FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeChatMessageReadReceiptsCollection(document.RootElement);
        }
    }
}
