// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.Chat
{
    /// <summary> A chat message read receipt indicates the time a chat message was read by a recipient. </summary>
    internal partial class ChatMessageReadReceiptInternal
    {
        /// <summary> Initializes a new instance of <see cref="ChatMessageReadReceiptInternal"/>. </summary>
        /// <param name="senderCommunicationIdentifier"> Identifies a participant in Azure Communication services. A participant is, for example, a phone number or an Azure communication user. This model is polymorphic: Apart from kind and rawId, at most one further property may be set which must match the kind enum value. </param>
        /// <param name="chatMessageId"> Id of the chat message that has been read. This id is generated by the server. </param>
        /// <param name="readOn"> The time at which the message was read. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="senderCommunicationIdentifier"/> or <paramref name="chatMessageId"/> is null. </exception>
        internal ChatMessageReadReceiptInternal(CommunicationIdentifierModel senderCommunicationIdentifier, string chatMessageId, DateTimeOffset readOn)
        {
            Argument.AssertNotNull(senderCommunicationIdentifier, nameof(senderCommunicationIdentifier));
            Argument.AssertNotNull(chatMessageId, nameof(chatMessageId));

            SenderCommunicationIdentifier = senderCommunicationIdentifier;
            ChatMessageId = chatMessageId;
            ReadOn = readOn;
        }

        /// <summary> Identifies a participant in Azure Communication services. A participant is, for example, a phone number or an Azure communication user. This model is polymorphic: Apart from kind and rawId, at most one further property may be set which must match the kind enum value. </summary>
        public CommunicationIdentifierModel SenderCommunicationIdentifier { get; }
        /// <summary> Id of the chat message that has been read. This id is generated by the server. </summary>
        public string ChatMessageId { get; }
        /// <summary> The time at which the message was read. The timestamp is in RFC3339 format: `yyyy-MM-ddTHH:mm:ssZ`. </summary>
        public DateTimeOffset ReadOn { get; }
    }
}
