// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Communication.Chat
{
    internal partial class ChatMessageContentInternal
    {
        internal static ChatMessageContentInternal DeserializeChatMessageContentInternal(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string message = default;
            string topic = default;
            IReadOnlyList<ChatParticipantInternal> participants = default;
            IReadOnlyList<ChatAttachmentInternal> attachments = default;
            CommunicationIdentifierModel initiatorCommunicationIdentifier = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("message"u8))
                {
                    message = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("topic"u8))
                {
                    topic = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("participants"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ChatParticipantInternal> array = new List<ChatParticipantInternal>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ChatParticipantInternal.DeserializeChatParticipantInternal(item));
                    }
                    participants = array;
                    continue;
                }
                if (property.NameEquals("attachments"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ChatAttachmentInternal> array = new List<ChatAttachmentInternal>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ChatAttachmentInternal.DeserializeChatAttachmentInternal(item));
                    }
                    attachments = array;
                    continue;
                }
                if (property.NameEquals("initiatorCommunicationIdentifier"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    initiatorCommunicationIdentifier = CommunicationIdentifierModel.DeserializeCommunicationIdentifierModel(property.Value);
                    continue;
                }
            }
            return new ChatMessageContentInternal(message, topic, participants ?? new ChangeTrackingList<ChatParticipantInternal>(), attachments ?? new ChangeTrackingList<ChatAttachmentInternal>(), initiatorCommunicationIdentifier);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ChatMessageContentInternal FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeChatMessageContentInternal(document.RootElement);
        }
    }
}
