// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.Chat
{
    /// <summary> An attachment in a chat message. </summary>
    internal partial class ChatAttachmentInternal
    {
        /// <summary> Initializes a new instance of <see cref="ChatAttachmentInternal"/>. </summary>
        /// <param name="id"> Id of the attachment. </param>
        /// <param name="attachmentType"> The type of attachment. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        internal ChatAttachmentInternal(string id, ChatAttachmentType attachmentType)
        {
            Argument.AssertNotNull(id, nameof(id));

            Id = id;
            AttachmentType = attachmentType;
        }

        /// <summary> Initializes a new instance of <see cref="ChatAttachmentInternal"/>. </summary>
        /// <param name="id"> Id of the attachment. </param>
        /// <param name="attachmentType"> The type of attachment. </param>
        /// <param name="name"> The name of the attachment content. </param>
        /// <param name="url"> The URL where the attachment can be downloaded. </param>
        /// <param name="previewUrl"> The URL where the preview of attachment can be downloaded. </param>
        internal ChatAttachmentInternal(string id, ChatAttachmentType attachmentType, string name, Uri url, Uri previewUrl)
        {
            Id = id;
            AttachmentType = attachmentType;
            Name = name;
            Url = url;
            PreviewUrl = previewUrl;
        }

        /// <summary> Id of the attachment. </summary>
        public string Id { get; }
        /// <summary> The type of attachment. </summary>
        public ChatAttachmentType AttachmentType { get; }
        /// <summary> The name of the attachment content. </summary>
        public string Name { get; }
        /// <summary> The URL where the attachment can be downloaded. </summary>
        public Uri Url { get; }
        /// <summary> The URL where the preview of attachment can be downloaded. </summary>
        public Uri PreviewUrl { get; }
    }
}
