// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Communication.Chat
{
    /// <summary> Model factory for models. </summary>
    public static partial class ChatModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Chat.ChatError"/>. </summary>
        /// <param name="code"> The error code. </param>
        /// <param name="message"> The error message. </param>
        /// <param name="target"> The error target. </param>
        /// <param name="details"> Further details about specific errors that led to this error. </param>
        /// <param name="innerError"> The inner error if any. </param>
        /// <returns> A new <see cref="Chat.ChatError"/> instance for mocking. </returns>
        public static ChatError ChatError(string code = null, string message = null, string target = null, IEnumerable<ChatError> details = null, ChatError innerError = null)
        {
            details ??= new List<ChatError>();

            return new ChatError(code, message, target, details?.ToList(), innerError);
        }

        /// <summary> Initializes a new instance of <see cref="Chat.AddChatParticipantsResult"/>. </summary>
        /// <param name="invalidParticipants"> The participants that failed to be added to the chat thread. </param>
        /// <returns> A new <see cref="Chat.AddChatParticipantsResult"/> instance for mocking. </returns>
        public static AddChatParticipantsResult AddChatParticipantsResult(IEnumerable<ChatError> invalidParticipants = null)
        {
            invalidParticipants ??= new List<ChatError>();

            return new AddChatParticipantsResult(invalidParticipants?.ToList());
        }
    }
}
