// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Communication.CallingServer
{
    internal partial class StartCallRecordingRequestInternal : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("callLocator"u8);
            writer.WriteObjectValue(CallLocator);
            if (Optional.IsDefined(RecordingStateCallbackUri))
            {
                writer.WritePropertyName("recordingStateCallbackUri"u8);
                writer.WriteStringValue(RecordingStateCallbackUri);
            }
            if (Optional.IsDefined(RecordingContentType))
            {
                writer.WritePropertyName("recordingContentType"u8);
                writer.WriteStringValue(RecordingContentType.Value.ToString());
            }
            if (Optional.IsDefined(RecordingChannelType))
            {
                writer.WritePropertyName("recordingChannelType"u8);
                writer.WriteStringValue(RecordingChannelType.Value.ToString());
            }
            if (Optional.IsDefined(RecordingFormatType))
            {
                writer.WritePropertyName("recordingFormatType"u8);
                writer.WriteStringValue(RecordingFormatType.Value.ToString());
            }
            if (Optional.IsCollectionDefined(ChannelAffinity))
            {
                writer.WritePropertyName("channelAffinity"u8);
                writer.WriteStartArray();
                foreach (var item in ChannelAffinity)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
