// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.CallingServer
{
    /// <summary> Determines the type of the recognition. </summary>
    public readonly partial struct RecognizeInputType : IEquatable<RecognizeInputType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecognizeInputType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecognizeInputType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DtmfValue = "dtmf";

        /// <summary> dtmf. </summary>
        public static RecognizeInputType Dtmf { get; } = new RecognizeInputType(DtmfValue);
        /// <summary> Determines if two <see cref="RecognizeInputType"/> values are the same. </summary>
        public static bool operator ==(RecognizeInputType left, RecognizeInputType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecognizeInputType"/> values are not the same. </summary>
        public static bool operator !=(RecognizeInputType left, RecognizeInputType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecognizeInputType"/>. </summary>
        public static implicit operator RecognizeInputType(string value) => new RecognizeInputType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecognizeInputType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecognizeInputType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
