// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Communication.CallingServer;

namespace Azure.Communication
{
    /// <summary> The MicrosoftTeamsUserIdentifierModel. </summary>
    internal partial class MicrosoftTeamsUserIdentifierModel
    {
        /// <summary> Initializes a new instance of <see cref="MicrosoftTeamsUserIdentifierModel"/>. </summary>
        /// <param name="userId"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="userId"/> is null. </exception>
        public MicrosoftTeamsUserIdentifierModel(string userId)
        {
            Argument.AssertNotNull(userId, nameof(userId));

            UserId = userId;
        }

        /// <summary> Initializes a new instance of <see cref="MicrosoftTeamsUserIdentifierModel"/>. </summary>
        /// <param name="userId"></param>
        /// <param name="isAnonymous"></param>
        /// <param name="cloud"></param>
        internal MicrosoftTeamsUserIdentifierModel(string userId, bool? isAnonymous, CommunicationCloudEnvironmentModel? cloud)
        {
            UserId = userId;
            IsAnonymous = isAnonymous;
            Cloud = cloud;
        }

        /// <summary> Gets or sets the user id. </summary>
        public string UserId { get; set; }
        /// <summary> Gets or sets the is anonymous. </summary>
        public bool? IsAnonymous { get; set; }
        /// <summary> Gets or sets the cloud. </summary>
        public CommunicationCloudEnvironmentModel? Cloud { get; set; }
    }
}
