// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.CallingServer
{
    /// <summary> The Tone. </summary>
    public readonly partial struct DtmfTone : IEquatable<DtmfTone>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DtmfTone"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DtmfTone(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ZeroValue = "zero";
        private const string OneValue = "one";
        private const string TwoValue = "two";
        private const string ThreeValue = "three";
        private const string FourValue = "four";
        private const string FiveValue = "five";
        private const string SixValue = "six";
        private const string SevenValue = "seven";
        private const string EightValue = "eight";
        private const string NineValue = "nine";
        private const string AValue = "a";
        private const string BValue = "b";
        private const string CValue = "c";
        private const string DValue = "d";
        private const string PoundValue = "pound";
        private const string AsteriskValue = "asterisk";

        /// <summary> zero. </summary>
        public static DtmfTone Zero { get; } = new DtmfTone(ZeroValue);
        /// <summary> one. </summary>
        public static DtmfTone One { get; } = new DtmfTone(OneValue);
        /// <summary> two. </summary>
        public static DtmfTone Two { get; } = new DtmfTone(TwoValue);
        /// <summary> three. </summary>
        public static DtmfTone Three { get; } = new DtmfTone(ThreeValue);
        /// <summary> four. </summary>
        public static DtmfTone Four { get; } = new DtmfTone(FourValue);
        /// <summary> five. </summary>
        public static DtmfTone Five { get; } = new DtmfTone(FiveValue);
        /// <summary> six. </summary>
        public static DtmfTone Six { get; } = new DtmfTone(SixValue);
        /// <summary> seven. </summary>
        public static DtmfTone Seven { get; } = new DtmfTone(SevenValue);
        /// <summary> eight. </summary>
        public static DtmfTone Eight { get; } = new DtmfTone(EightValue);
        /// <summary> nine. </summary>
        public static DtmfTone Nine { get; } = new DtmfTone(NineValue);
        /// <summary> a. </summary>
        public static DtmfTone A { get; } = new DtmfTone(AValue);
        /// <summary> b. </summary>
        public static DtmfTone B { get; } = new DtmfTone(BValue);
        /// <summary> c. </summary>
        public static DtmfTone C { get; } = new DtmfTone(CValue);
        /// <summary> d. </summary>
        public static DtmfTone D { get; } = new DtmfTone(DValue);
        /// <summary> pound. </summary>
        public static DtmfTone Pound { get; } = new DtmfTone(PoundValue);
        /// <summary> asterisk. </summary>
        public static DtmfTone Asterisk { get; } = new DtmfTone(AsteriskValue);
        /// <summary> Determines if two <see cref="DtmfTone"/> values are the same. </summary>
        public static bool operator ==(DtmfTone left, DtmfTone right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DtmfTone"/> values are not the same. </summary>
        public static bool operator !=(DtmfTone left, DtmfTone right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DtmfTone"/>. </summary>
        public static implicit operator DtmfTone(string value) => new DtmfTone(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DtmfTone other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DtmfTone other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
