// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Communication.CallingServer
{
    public partial class DtmfOptionsInternal : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(InterToneTimeoutInSeconds))
            {
                writer.WritePropertyName("interToneTimeoutInSeconds"u8);
                writer.WriteNumberValue(InterToneTimeoutInSeconds.Value);
            }
            if (Optional.IsDefined(MaxTonesToCollect))
            {
                writer.WritePropertyName("maxTonesToCollect"u8);
                writer.WriteNumberValue(MaxTonesToCollect.Value);
            }
            if (Optional.IsCollectionDefined(StopTones))
            {
                writer.WritePropertyName("stopTones"u8);
                writer.WriteStartArray();
                foreach (var item in StopTones)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
