// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Communication.CallingServer
{
    /// <summary> Channel affinity for a participant. </summary>
    internal partial class ChannelAffinityInternal
    {
        /// <summary> Initializes a new instance of <see cref="ChannelAffinityInternal"/>. </summary>
        public ChannelAffinityInternal()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ChannelAffinityInternal"/>. </summary>
        /// <param name="channel"> Channel number to which bitstream from a particular participant will be written. </param>
        /// <param name="participant">
        /// The identifier for the participant whose bitstream will be written to the channel
        /// represented by the channel number.
        /// </param>
        internal ChannelAffinityInternal(int? channel, CommunicationIdentifierModel participant)
        {
            Channel = channel;
            Participant = participant;
        }

        /// <summary> Channel number to which bitstream from a particular participant will be written. </summary>
        public int? Channel { get; set; }
    }
}
