// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.CallingServer
{
    /// <summary> The request payload for answering the call. </summary>
    internal partial class AnswerCallRequestInternal
    {
        /// <summary> Initializes a new instance of <see cref="AnswerCallRequestInternal"/>. </summary>
        /// <param name="incomingCallContext"> The context associated with the call. </param>
        /// <param name="callbackUri"> The callback uri. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="incomingCallContext"/> or <paramref name="callbackUri"/> is null. </exception>
        public AnswerCallRequestInternal(string incomingCallContext, string callbackUri)
        {
            Argument.AssertNotNull(incomingCallContext, nameof(incomingCallContext));
            Argument.AssertNotNull(callbackUri, nameof(callbackUri));

            IncomingCallContext = incomingCallContext;
            CallbackUri = callbackUri;
        }

        /// <summary> Initializes a new instance of <see cref="AnswerCallRequestInternal"/>. </summary>
        /// <param name="incomingCallContext"> The context associated with the call. </param>
        /// <param name="callbackUri"> The callback uri. </param>
        /// <param name="mediaStreamingConfiguration"> Media Streaming Configuration. </param>
        internal AnswerCallRequestInternal(string incomingCallContext, string callbackUri, MediaStreamingOptionsInternal mediaStreamingConfiguration)
        {
            IncomingCallContext = incomingCallContext;
            CallbackUri = callbackUri;
            MediaStreamingConfiguration = mediaStreamingConfiguration;
        }

        /// <summary> The context associated with the call. </summary>
        public string IncomingCallContext { get; }
        /// <summary> The callback uri. </summary>
        public string CallbackUri { get; }
        /// <summary> Media Streaming Configuration. </summary>
        public MediaStreamingOptionsInternal MediaStreamingConfiguration { get; set; }
    }
}
