﻿// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Communication.CallAutomation
{
    /// <summary> Options of live transcription. </summary>
    public partial class TranscriptionOptions
    {
        /// <summary> Initializes a new instance of TranscriptionOptions. </summary>
        /// <param name="transportUri"> Transport URL for live transcription. </param>
        /// <param name="transportType"> The type of transport to be used for live transcription, eg. Websocket. </param>
        /// <param name="locale"> Defines the locale for the data e.g en-CA, en-AU. </param>
        /// <param name="startTranscription"> Determines if the transcription should be started immediately after call is answered or not. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="transportUri"/> or <paramref name="locale"/> is null. </exception>
        public TranscriptionOptions(Uri transportUri, TranscriptionTransport transportType, string locale, bool startTranscription)
        {
            Argument.AssertNotNull(transportUri, nameof(transportUri));
            Argument.AssertNotNull(locale, nameof(locale));

            TransportUrl = transportUri;
            TranscriptionTransport = transportType;
            Locale = locale;
            StartTranscription = startTranscription;
        }

        /// <summary> Transport URL for live transcription. </summary>
        public Uri TransportUrl { get; }
        /// <summary> The type of transport to be used for live transcription, eg. Websocket. </summary>
        public TranscriptionTransport TranscriptionTransport { get; }
        /// <summary> Defines the locale for the data e.g en-CA, en-AU. </summary>
        public string Locale { get; }
        /// <summary> Determines if the transcription should be started immediately after call is answered or not. </summary>
        public bool StartTranscription { get; }
    }
}
