// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.CallAutomation
{
    /// <summary> The request payload for holding participant from the call. </summary>
    internal partial class UnholdRequestInternal
    {
        /// <summary> Initializes a new instance of <see cref="UnholdRequestInternal"/>. </summary>
        /// <param name="targetParticipant">
        /// Participants to be hold from the call.
        /// Only ACS Users are supported.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="targetParticipant"/> is null. </exception>
        public UnholdRequestInternal(CommunicationIdentifierModel targetParticipant)
        {
            Argument.AssertNotNull(targetParticipant, nameof(targetParticipant));

            TargetParticipant = targetParticipant;
        }

        /// <summary> Initializes a new instance of <see cref="UnholdRequestInternal"/>. </summary>
        /// <param name="targetParticipant">
        /// Participants to be hold from the call.
        /// Only ACS Users are supported.
        /// </param>
        /// <param name="operationContext"> Used by customers when calling mid-call actions to correlate the request to the response event. </param>
        internal UnholdRequestInternal(CommunicationIdentifierModel targetParticipant, string operationContext)
        {
            TargetParticipant = targetParticipant;
            OperationContext = operationContext;
        }

        /// <summary>
        /// Participants to be hold from the call.
        /// Only ACS Users are supported.
        /// </summary>
        public CommunicationIdentifierModel TargetParticipant { get; }
        /// <summary> Used by customers when calling mid-call actions to correlate the request to the response event. </summary>
        public string OperationContext { get; set; }
    }
}
