// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Communication.CallAutomation
{
    public partial class TranscriptionUpdate
    {
        internal static TranscriptionUpdate DeserializeTranscriptionUpdate(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            TranscriptionStatus? transcriptionStatus = default;
            TranscriptionStatusDetails? transcriptionStatusDetails = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("transcriptionStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    transcriptionStatus = new TranscriptionStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("transcriptionStatusDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    transcriptionStatusDetails = new TranscriptionStatusDetails(property.Value.GetString());
                    continue;
                }
            }
            return new TranscriptionUpdate(transcriptionStatus, transcriptionStatusDetails);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static TranscriptionUpdate FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeTranscriptionUpdate(document.RootElement);
        }
    }
}
