// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.CallAutomation
{
    /// <summary> The SsmlSource. </summary>
    internal partial class SsmlSourceInternal
    {
        /// <summary> Initializes a new instance of <see cref="SsmlSourceInternal"/>. </summary>
        /// <param name="ssmlText"> Ssml string for the cognitive service to be played. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ssmlText"/> is null. </exception>
        public SsmlSourceInternal(string ssmlText)
        {
            Argument.AssertNotNull(ssmlText, nameof(ssmlText));

            SsmlText = ssmlText;
        }

        /// <summary> Initializes a new instance of <see cref="SsmlSourceInternal"/>. </summary>
        /// <param name="ssmlText"> Ssml string for the cognitive service to be played. </param>
        /// <param name="customVoiceEndpointId"> Endpoint where the custom voice was deployed. </param>
        internal SsmlSourceInternal(string ssmlText, string customVoiceEndpointId)
        {
            SsmlText = ssmlText;
            CustomVoiceEndpointId = customVoiceEndpointId;
        }

        /// <summary> Ssml string for the cognitive service to be played. </summary>
        public string SsmlText { get; }
        /// <summary> Endpoint where the custom voice was deployed. </summary>
        public string CustomVoiceEndpointId { get; set; }
    }
}
