// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Communication.CallAutomation
{
    public partial class SpeechResult
    {
        internal static SpeechResult DeserializeSpeechResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string speech = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("speech"u8))
                {
                    speech = property.Value.GetString();
                    continue;
                }
            }
            return new SpeechResult(speech);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SpeechResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSpeechResult(document.RootElement);
        }
    }
}
