// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Communication.CallAutomation
{
    /// <summary> The SendDtmfTonesRequest. </summary>
    internal partial class SendDtmfTonesRequestInternal
    {
        /// <summary> Initializes a new instance of <see cref="SendDtmfTonesRequestInternal"/>. </summary>
        /// <param name="tones"> List of tones to be sent to target participant. </param>
        /// <param name="targetParticipant"> Target participant of send Dtmf tones. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="tones"/> or <paramref name="targetParticipant"/> is null. </exception>
        public SendDtmfTonesRequestInternal(IEnumerable<DtmfTone> tones, CommunicationIdentifierModel targetParticipant)
        {
            Argument.AssertNotNull(tones, nameof(tones));
            Argument.AssertNotNull(targetParticipant, nameof(targetParticipant));

            Tones = tones.ToList();
            TargetParticipant = targetParticipant;
        }

        /// <summary> Initializes a new instance of <see cref="SendDtmfTonesRequestInternal"/>. </summary>
        /// <param name="tones"> List of tones to be sent to target participant. </param>
        /// <param name="targetParticipant"> Target participant of send Dtmf tones. </param>
        /// <param name="operationContext"> The value to identify context of the operation. </param>
        /// <param name="operationCallbackUri">
        /// Set a callback URI that overrides the default callback URI set by CreateCall/AnswerCall for this operation.
        /// This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
        /// </param>
        internal SendDtmfTonesRequestInternal(IList<DtmfTone> tones, CommunicationIdentifierModel targetParticipant, string operationContext, string operationCallbackUri)
        {
            Tones = tones;
            TargetParticipant = targetParticipant;
            OperationContext = operationContext;
            OperationCallbackUri = operationCallbackUri;
        }

        /// <summary> List of tones to be sent to target participant. </summary>
        public IList<DtmfTone> Tones { get; }
        /// <summary> Target participant of send Dtmf tones. </summary>
        public CommunicationIdentifierModel TargetParticipant { get; }
        /// <summary> The value to identify context of the operation. </summary>
        public string OperationContext { get; set; }
        /// <summary>
        /// Set a callback URI that overrides the default callback URI set by CreateCall/AnswerCall for this operation.
        /// This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
        /// </summary>
        public string OperationCallbackUri { get; set; }
    }
}
