// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Communication.CallAutomation
{
    /// <summary> The ResultInformation. </summary>
    public partial class ResultInformation
    {
        /// <summary> Initializes a new instance of <see cref="ResultInformation"/>. </summary>
        internal ResultInformation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResultInformation"/>. </summary>
        /// <param name="code"> Code of the current result. This can be helpful to Call Automation team to troubleshoot the issue if this result was unexpected. </param>
        /// <param name="subCode"> Subcode of the current result. This can be helpful to Call Automation team to troubleshoot the issue if this result was unexpected. </param>
        /// <param name="message"> Detail message that describes the current result. </param>
        internal ResultInformation(int? code, int? subCode, string message)
        {
            Code = code;
            SubCode = subCode;
            Message = message;
        }

        /// <summary> Code of the current result. This can be helpful to Call Automation team to troubleshoot the issue if this result was unexpected. </summary>
        public int? Code { get; }
        /// <summary> Subcode of the current result. This can be helpful to Call Automation team to troubleshoot the issue if this result was unexpected. </summary>
        public int? SubCode { get; }
        /// <summary> Detail message that describes the current result. </summary>
        public string Message { get; }
    }
}
