// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.CallAutomation
{
    /// <summary> The remove participant by identifier request. </summary>
    internal partial class RemoveParticipantRequestInternal
    {
        /// <summary> Initializes a new instance of <see cref="RemoveParticipantRequestInternal"/>. </summary>
        /// <param name="participantToRemove"> The participants to be removed from the call. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="participantToRemove"/> is null. </exception>
        public RemoveParticipantRequestInternal(CommunicationIdentifierModel participantToRemove)
        {
            Argument.AssertNotNull(participantToRemove, nameof(participantToRemove));

            ParticipantToRemove = participantToRemove;
        }

        /// <summary> Initializes a new instance of <see cref="RemoveParticipantRequestInternal"/>. </summary>
        /// <param name="participantToRemove"> The participants to be removed from the call. </param>
        /// <param name="operationContext"> Used by customers when calling mid-call actions to correlate the request to the response event. </param>
        /// <param name="operationCallbackUri">
        /// Set a callback URI that overrides the default callback URI set by CreateCall/AnswerCall for this operation.
        /// This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
        /// </param>
        internal RemoveParticipantRequestInternal(CommunicationIdentifierModel participantToRemove, string operationContext, string operationCallbackUri)
        {
            ParticipantToRemove = participantToRemove;
            OperationContext = operationContext;
            OperationCallbackUri = operationCallbackUri;
        }

        /// <summary> The participants to be removed from the call. </summary>
        public CommunicationIdentifierModel ParticipantToRemove { get; }
        /// <summary> Used by customers when calling mid-call actions to correlate the request to the response event. </summary>
        public string OperationContext { get; set; }
        /// <summary>
        /// Set a callback URI that overrides the default callback URI set by CreateCall/AnswerCall for this operation.
        /// This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
        /// </summary>
        public string OperationCallbackUri { get; set; }
    }
}
