// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.CallAutomation
{
    /// <summary> The RecordingStateChanged. </summary>
    public partial class RecordingStateChanged
    {
        /// <summary> Initializes a new instance of <see cref="RecordingStateChanged"/>. </summary>
        internal RecordingStateChanged()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RecordingStateChanged"/>. </summary>
        /// <param name="recordingId"> The call recording id. </param>
        /// <param name="state"></param>
        /// <param name="startDateTime"> The time of the recording started. </param>
        /// <param name="recordingKind"></param>
        /// <param name="callConnectionId"> Call connection ID. </param>
        /// <param name="serverCallId"> Server call ID. </param>
        /// <param name="correlationId"> Correlation ID for event to call correlation. Also called ChainId for skype chain ID. </param>
        internal RecordingStateChanged(string recordingId, RecordingState state, DateTimeOffset? startDateTime, RecordingKind? recordingKind, string callConnectionId, string serverCallId, string correlationId)
        {
            RecordingId = recordingId;
            State = state;
            StartDateTime = startDateTime;
            RecordingKind = recordingKind;
            CallConnectionId = callConnectionId;
            ServerCallId = serverCallId;
            CorrelationId = correlationId;
        }

        /// <summary> The call recording id. </summary>
        public string RecordingId { get; }
        /// <summary> The time of the recording started. </summary>
        public DateTimeOffset? StartDateTime { get; }
        /// <summary> Gets the recording kind. </summary>
        public RecordingKind? RecordingKind { get; }
    }
}
