// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.CallAutomation
{
    /// <summary> The RecordingKind. </summary>
    public readonly partial struct RecordingKind : IEquatable<RecordingKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecordingKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecordingKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureCommunicationServicesValue = "azureCommunicationServices";
        private const string TeamsValue = "teams";
        private const string TeamsComplianceValue = "teamsCompliance";

        /// <summary> azureCommunicationServices. </summary>
        public static RecordingKind AzureCommunicationServices { get; } = new RecordingKind(AzureCommunicationServicesValue);
        /// <summary> teams. </summary>
        public static RecordingKind Teams { get; } = new RecordingKind(TeamsValue);
        /// <summary> teamsCompliance. </summary>
        public static RecordingKind TeamsCompliance { get; } = new RecordingKind(TeamsComplianceValue);
        /// <summary> Determines if two <see cref="RecordingKind"/> values are the same. </summary>
        public static bool operator ==(RecordingKind left, RecordingKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecordingKind"/> values are not the same. </summary>
        public static bool operator !=(RecordingKind left, RecordingKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecordingKind"/>. </summary>
        public static implicit operator RecordingKind(string value) => new RecordingKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecordingKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecordingKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
